package gov.va.vamf.scheduling.direct.domain;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.Optional;
import java.util.function.Predicate;

@XmlAccessorType(value = XmlAccessType.NONE)
@XmlRootElement(namespace = Namespace.VarUtility)
public class CustomRequestSettings extends DomainBaseObjects<CustomRequestSetting> {
    public Optional<CustomRequestSetting> findCustomRequestSettingById(final String id) {
        return this
                .stream()
                .filter(new Predicate<CustomRequestSetting>() { // TODO: switch to lambda
                    @Override
                    public boolean test(final CustomRequestSetting setting) {
                        return setting.getId().equals(id);
                    }
                })
                .findFirst();
    }
}
